;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Bootleg "Krack The Hack" Cutscene System
;	By Daizo Dee Von
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @ Faro
; If you need a cutscene to end the level instead, you can set that
; up in Lunar Magic linking a secondary exit to the overworld.
;
; Also, this uses screen exits so put the cutscene in the last 
; screen of your cutscene.
;
; Thanks for the Jinker Bolts poster.
;
; Also I lied, I started this when you asked me to start early.
;
; :)
;
; Love youuuuuuuuu    no homo
;	~ Daizo Dee Von
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; change these if needed
!FREERAM = $18C5|!addr		; freeram that resets per sublevel

; don't change this
!Brightness = $0DAE|!addr

!StatusBarToggle = $79	; must match RAMToggledStatusbar.asm

load:

init:
	STZ $1411|!addr : STZ $1412|!addr	; disable vertical/horizontal scroll
	JSR NoInputs ; prevents first frame inputs
	RTL

main:
	JSR DeletePlayer
	JSR CutsceneSystem
    JSR NoInputs
	JSR MusicChange
	RTL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CutsceneSystem:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	LDA #$02 : STA $55

	LDA !FREERAM
	JSL $0086DF
		dw .AwaitInput
		dw .DecreaseBrightness
		dw .ScrollScreen
		dw .IncreaseBrightness

.AwaitInput
	; If START or SELECT is selected, skip cutscene
	LDA $16
	AND #$30
	BNE .TeleportInstead
	
	; Otherwise if A/B are pressed, proceed to next screen
	LDA $16
	ORA $18
	AND #$80
	BEQ +
	
	; Check to see if we're already on the final screen
	LDA $1463|!addr
	INC A
	CMP $5E
	BEQ .TeleportInstead
	
	; Proceed the cutscene
	INC !FREERAM
+	RTS
.TeleportInstead
	STZ $1497|!addr
	; screen exit
	LDA #$06
	STA $71
	STZ $88
	STZ $89
	RTS

.DecreaseBrightness
	LDX #$01
-	LDA !Brightness
	BNE +
	INC !FREERAM
	RTS
+	DEC !Brightness
	DEX
	BPL -
	RTS

.ScrollScreen
	LDX #$07
-	REP #$20
	INC $1462|!addr
	INC $94
	SEP #$20
	LDA $1462|!addr
	BEQ + ; until 00 again
	DEX
	BPL -
	RTS
+	INC !FREERAM
	RTS

.IncreaseBrightness
	LDX #$01
-	LDA !Brightness
	CMP #$0F
	BNE +
	STZ !FREERAM
	RTS
+	INC !Brightness
	DEX
	BPL -
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DeletePlayer:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; disable momentum/gravity
	STZ $7B : STZ $7D

; disable player
	LDA #$7F : STA $78		; player invisible
	STA $1497|!addr				; player involnerability
	LDA #$01 : STA $185C|!addr	; disable interaction with objects
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
NoInputs:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; disable all inputs
	LDX #$03
-	STZ $15,x
	DEX : BPL -

; disable pause
	LDA #$F0 : STA $13D3|!addr
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MusicChange:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This should change music depending on what screen the player is in. Can also play SFX (id imagine?)

	LDA $95
	CMP #$03
	BEQ BeginMusic
	RTS

BeginMusic:
	LDA #$39
	STA $1DFB|!addr
	RTS

FADE:
	LDA #$FE
	STA $1DFB|!addr
	RTS

Toadsworth:
	LDA #$30
	STA $1DFB|!addr
	RTS

